#!/bin/bash
#SBATCH --ntasks-per-node=2
#SBATCH --time=20:00:00

cd $SLURM_SUBMIT_DIR


# Submit chrX and Y separately

module load ensembl-vep

# Split vcf or gzvcf to annotate by chromosome. $1 is your vcf to annotate (without header)

grep -w "chrX" $1 > vcf_chrX;
cat vcf_header vcf_chrX > vcf_to_anno_chrX.vcf;
rm vcf_chrX
 
#VEP Annotation

vep -i vcf_to_anno_chrX.vcf --cache --force_overwrite --pick_allele \
 --custom ../software/gnomAD/GRCh38/gnomad.exomes.r2.1.1.sites.liftover_grch38.vcf.bgz,gnomadE,vcf,exact,,AF \
 --plugin CADD,../software/CADD_V1.6/CADD-scripts/data/annotations/GRCh38_v1.6/no_anno/whole_genome_SNVs.tsv.gz,..software/CADD_V1.6/CADD-scripts/data/annotations/GRCh38_v1.6/no_anno/gnomad.genomes.r3.0.indel.tsv \
 --vcf  --fields "Allele,Consequence,SYMBOL,Gene,gnomadE_AF,CADD_RAW" -o ANNO_CHRX.vcf --offline

